function prtid=print_file(filename,prof,vad)
% prints the profile information contained in the structure prof to file
% named filename

fid2=fopen(filename,'w');

% Write Header

fprintf(fid2,'%s\n',['Filename: ',char(vad.orig_filename)])
fprintf(fid2,'%s\n',['System ID: ',num2str(vad.system_id)])
fprintf(fid2,'%s\n',['Number of gates: ',num2str(vad.number_of_gates)])
fprintf(fid2,'%s\n',['Range gate length (m): ',num2str(vad.range_gate_length)])
fprintf(fid2,'%s\n',['Pulses/ray: ',num2str(vad.pulses_per_ray)])
fprintf(fid2,'%s\n',['Scan type: ',char(vad.scan_type)])
fprintf(fid2,'%s\n',['Focus range: ',num2str(vad.focus_range)])
fprintf(fid2,'%s\n',['Start time: ',datestr(vad.start_time)])
fprintf(fid2,'%s\n',['Resolution (m/s):	',num2str(vad.resolution)])
fprintf(fid2,'%s\n','Data line : Height (m), u(m/s), v(m/s), w(m/s), Vh(m/s), theta(degrees), residual(m/s)')
fprintf(fid2,'%s\n','f7.2,1x,f6.2,1x,f6.2,1x,f6.2,1x,f6.2,1x,f6.2,1x,f6.2,1x')
fprintf(fid2,'%s\n','****')

nlength=length(prof.u);
ind=isnan(prof.u);
prof.u(ind)=-999;
prof.v(ind)=-999;
prof.w(ind)=-999;
prof.Vh(ind)=-999;
prof.theta(ind)=-999;
prof.turb(ind)=-999;
for j=1:nlength
fprintf(fid2,'%7.2f %7.2f %7.2f %7.2f %7.2f %7.2f %7.2f  \n', ...
    [prof.heights(j),prof.u(j),prof.v(j),prof.w(j),prof.Vh(j), ...
    prof.theta(j), prof.turb(j)]);
end
prtid=fclose(fid2);
return

    